
//////////////////////////Like star wars by Rene Pol aka Realspawn -rp-interactive.nl   10-03-2016////////////////////

#define PRAGMA_PATH "3Dmodels"
#define PRAGMA_PATH "Graphics"

#define PRAGMA_PATH "Sounds"

var soundtrack_handle;

ENTITY*ship;

BMAP* effect_tga = "spark.tga";
function my_effect(PARTICLE *p)
{

	p.lifespan =0.05; 
	p.alpha = 70;
	p.bmap = effect_tga;
	p.size = 8;
	p.flags |= (BRIGHT | MOVE | TRANSLUCENT);
	p.event = NULL;

}




ENTITY* sky = 
{
	type = "spacecube1+6.bmp"; 
	flags2 = SKY | CUBE | SHOW;
}
SOUND* laser_snd = "laser.wav";

var effect_volume = 50; 
var effect_range = 400; 

SOUND* explosion_snd = "explosion.wav";





function sprite_played()
{


	set (my, PASSABLE | BRIGHT | TRANSLUCENT);
	my.scale_x = 1.2; // we scale it down to 0.15 
	my.scale_y = my.scale_x; 
	my.ambient = 100;
	my.roll = random(360); 
	my.alpha = 100;	while (my.frame < 16) 
	{	
		my.frame += 2 * time_step; 
		wait (1);
	}
	while (my.alpha > 0) 
	{
		my.alpha -= 3 * time_step; 
		wait (1);
	}
	ent_remove (me);
}





function main()
{

	video_set(1024,768,0,0);
	shadow_stencil = 2;
	level_load("lstarwars.WMB");
	soundtrack_handle = media_loop("ingame.mp3", NULL, 100);
	fog_color = 1; 	
	camera.fog_start = 0.4 * camera.clip_far; // fog starts at 80% of clip range
	camera.fog_end = 2 * camera.clip_far;
	camera.clip_near =1;
	camera.clip_far  = 70000;

}


STRING* muzzle_tga = "muzzle.tga";
function display_muzzle();

action laser_boom()
{
	SOUND* explosion_wav = "explosion.wav";

	set(my,PASSABLE | INVISIBLE);

	ent_create("explo2+16.tga", vector(my.x,my.y,my.z+70), sprite_played);

	ent_playsound2(my,explosion_wav,800,15000);
	wait(1);
}



function remove_laser()
{



	SOUND* explosion_wav = "explosion.wav";


	set(my,INVISIBLE | PASSABLE);
	my.event = NULL;
	while(1)
	{


		ent_create("laser.mdl", vector(my.x,my.y,my.z+50), laser_boom);
		ent_create("explo2+16.tga", vector(my.x,my.y,my.z+70), sprite_played);
		wait(1);
		ent_remove(me);
		break;

	}

}

function m_flash()
{

	set(my,BRIGHT);

	my.pan = -90;
	my.roll = 90;
	wait(1);
	ent_remove(me);
}



function move_laser()
{


	my.emask = ENABLE_IMPACT | ENABLE_ENTITY | ENABLE_BLOCK; 
	my.event = remove_laser;
	set(my,BRIGHT | TRANSLUCENT | PASSABLE);
	my.pan = ship.pan;

	my.tilt = ship.tilt;
	my.roll = ship.roll;
	my.alpha =80;
	while(1)
	{

		my.roll +=1*time_step;
		c_move(my, vector(520 * time_step, 0, 0), nullvector, GLIDE |IGNORE_SPRITES | IGNORE_PASSABLE);	
		wait(1);
		if (vec_dist (my.x, ship.x) > 100)
		reset (my, PASSABLE);
		if (vec_dist (my.x, ship.x) > 100000)
		remove_laser();
	}
}


var switch_position =0;

function blast_laser()
{

	VECTOR gun_pos;
	VECTOR gun_pos2;
	VECTOR temp1;
	VECTOR temp2;
	if(switch_position ==0){
		wait(1);
		 vec_for_vertex (temp1.x, ship, 1624);
		snd_play (laser_snd, 100, 0);

		vec_for_vertex(&gun_pos, ship, 1624); 
			ent_create (muzzle_tga, temp1.x, display_muzzle); 
		ENTITY *laser = ent_create ("laser.mdl", &gun_pos, move_laser);
	


		switch_position +=1;
		wait(1);

	}
	else
	{


wait(1);
 vec_for_vertex (temp2.x, ship, 1625);
		snd_play (laser_snd, 100, 0);
		vec_for_vertex(&gun_pos2, ship, 1625);
			ent_create (muzzle_tga, temp2.x, display_muzzle); 
		ENTITY *laser = ent_create ("laser.mdl", &gun_pos2, move_laser);
	
		switch_position -=1;
		wait(1);

	}
}


function display_muzzle()
{
       set (my, PASSABLE | BRIGHT);
       my.roll = ship.roll;
       my.ambient = 100; 
       my.pan = ship.pan; 
       my.tilt = ship.tilt; 
   
       my.scale_x = 0.5; 
       my.scale_y = my.scale_x; 
       my.scale_z = my.scale_z; 
       ship.ambient = 100; 
       wait (3); 
       ship.ambient = 0; 
       ent_remove (me); 

}

var rotate = 0;


function ship_hit()
{
	my.skill100 -=10;
	if(my.skill100 <=0){
		snd_play(explosion_snd,100,0);	
		set(my,INVISIBLE | PASSABLE);
		my.event = NULL;
		ent_create("explo2+16.tga", vector(my.x,my.y,my.z+70), sprite_played);
		ent_create("explo2+16.tga", vector(my.x-50,my.y,my.z+70), sprite_played);
		ent_create("explo2+16.tga", vector(my.x,my.y,my.z-70), sprite_played);
		wait(1);
		ent_remove(me);

	}
}






action player_ship()
{
	wait(1);
	my.emask = ENABLE_IMPACT | ENABLE_ENTITY | ENABLE_BLOCK; 
	my.event = ship_hit;
	ship = me;
	set(my,SHADOW | METAL );
	on_space = blast_laser;

	VECTOR temp1;
	VECTOR temp2;
	VECTOR temp3;
	VECTOR temp4;
	my.skill100 = 100;
	while(1)
	{
		
		vec_for_vertex(temp1, my, 1626 ); 
		effect(my_effect, 1, temp1.x, nullvector);
		vec_for_vertex(temp2, my, 1627); 
		effect(my_effect, 1, temp2.x, nullvector);
		vec_for_vertex(temp3, my, 1628);
		effect(my_effect, 1, temp3.x, nullvector);
		vec_for_vertex(temp4, my, 1629); 
		effect(my_effect, 1, temp4.x, nullvector);
		if (key_cul) 
		{
			if (my.roll > -30)
			{
				
				my.roll -= 5 * time_step;
			} 
		}
		else
		{
			if (my.roll < 0)
			{
				my.roll += 4 * time_step;
			} 
		}
		if (key_cur) 
		{
			if (my.roll < 30)
			{
				my.roll += 5 * time_step;
			}
		}
		else
		{
			if (my.roll > 0)
			{
				my.roll -= 4 * time_step;
			} 
		}


		my.pan += 5 * (key_cul - key_cur) * time_step;
		my.tilt += 5 * (key_cud - key_cuu) * time_step;
		c_move(my, vector(200 * time_step, 0, 0), nullvector, GLIDE | IGNORE_SPRITES | IGNORE_PASSABLE);

		camera.x = ship.x - 450 * cos(ship.pan); 
		camera.y = ship.y - 450 * sin(ship.pan);
		camera.z = ship.z+150 ; 
		camera.pan = ship.pan; 
		camera.tilt = -15;
		wait (1);


	}
}


function remove_ship()
{
	my.skill100 -=1;
	if(my.skill100 ==0){
		snd_play(explosion_snd,100,0);	
		set(my,INVISIBLE | PASSABLE);
		my.event = NULL;
		ent_create("explo2+16.tga", vector(my.x,my.y,my.z+70), sprite_played);
		ent_create("explo2+16.tga", vector(my.x-50,my.y,my.z+70), sprite_played);
		ent_create("explo2+16.tga", vector(my.x,my.y,my.z-70), sprite_played);
		wait(1);
		ent_remove(me);

	}
	else
	{
		
		my.tilt = -20;

	}
}



action enemy_ships()
{
	my.emask = ENABLE_IMPACT | ENABLE_ENTITY | ENABLE_BLOCK; 
	my.event = remove_ship;
	set(my,METAL | SHADOW);
	my.skill100 = 2;
	while(1)
	{
		my.pan +=1*time_step;
		c_move(my, vector(40 * time_step, 0, 0), nullvector, GLIDE | IGNORE_SPRITES | IGNORE_PASSABLE);
		wait(1);
	}
}


action enemy_ships2()
{
	my.emask = ENABLE_IMPACT | ENABLE_ENTITY | ENABLE_BLOCK; 
	my.event = remove_ship;
	set(my,METAL | SHADOW);
	my.skill100 = 2;
	while(1)
	{
		my.pan -=1*time_step;
		c_move(my, vector(40 * time_step, 0, 0), nullvector, GLIDE | IGNORE_SPRITES | IGNORE_PASSABLE);
		wait(1);
	}
}


action terrain_ground()
{

	set(my,POLYGON);

}
